
<?php
require_once '../config.php';

// Only allow admin or support to view/manage users
$caller = verifyRole(['admin', 'support']);

$method = $_SERVER['REQUEST_METHOD'];
$action = basename($_SERVER['PHP_SELF'], '.php');

// Simple routing within the admin/users context
if ($method === 'GET') {
    // List all users
    try {
        $stmt = $pdo->query("SELECT id, email, credits_balance as credits, plan_type as plan, role, status, created_at FROM users ORDER BY created_at DESC");
        $users = $stmt->fetchAll();
        echo json_encode($users);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
} elseif ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $targetUserId = $data['userId'] ?? null;

    if (!$targetUserId) {
        http_response_code(400);
        echo json_encode(['error' => 'User ID is required']);
        exit;
    }

    // Ensure only admin can change roles or delete users
    if (isset($data['role']) || strpos($_SERVER['REQUEST_URI'], 'delete') !== false) {
        verifyRole(['admin']);
    }

    try {
        if (strpos($_SERVER['REQUEST_URI'], 'delete') !== false) {
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
            $stmt->execute([$targetUserId]);
            echo json_encode(['success' => true]);
        } else {
            // Update user
            $fields = [];
            $params = [];
            
            $allowedFields = ['credits', 'plan', 'role', 'status'];
            foreach ($allowedFields as $field) {
                if (isset($data[$field])) {
                    $dbField = ($field === 'credits') ? 'credits_balance' : (($field === 'plan') ? 'plan_type' : $field);
                    $fields[] = "$dbField = ?";
                    $params[] = $data[$field];
                }
            }
            
            if (empty($fields)) {
                echo json_encode(['error' => 'No fields to update']);
                exit;
            }

            $params[] = $targetUserId;
            $sql = "UPDATE users SET " . implode(', ', $fields) . " WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            
            echo json_encode(['success' => true]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
}
?>
