
<?php
require_once 'config.php';

// Endpoint for Stripe Webhook
if (isset($_GET['webhook']) && $_GET['webhook'] === 'stripe') {
    $payload = file_get_contents('php://input');
    $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
    // In production, verify signature with Stripe Library
    $event = json_decode($payload, true);

    if ($event['type'] === 'checkout.session.completed') {
        $session = $event['data']['object'];
        $userId = $session['client_reference_id'];
        $amount = $session['amount_total'] / 100;
        
        // Logic to determine credits based on amount
        $credits = ($amount >= 129) ? 50000 : 10000;

        $stmt = $pdo->prepare("UPDATE users SET credits_balance = credits_balance + ?, plan_type = ? WHERE id = ?");
        $stmt->execute([$credits, ($amount >= 129 ? 'pro' : 'free'), $userId]);
    }
    exit;
}

// Endpoint for Crypto Callback (Simulated)
if (isset($_GET['webhook']) && $_GET['webhook'] === 'crypto') {
    $data = json_decode(file_get_contents('php://input'), true);
    if ($data['status'] === 'confirmed') {
        $userId = $data['user_id'];
        $credits = $data['credits'];
        $pdo->prepare("UPDATE users SET credits_balance = credits_balance + ? WHERE id = ?")->execute([$credits, $userId]);
    }
    exit;
}
?>
