<?php
// PHP Backend Configuration
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

define('DB_HOST', 'localhost');
define('DB_NAME', 'moonzbqz_mailvity');
define('DB_USER', 'moonzbqz_mailvityuser');
define('DB_PASS', 'D77e{5Guj%sb');
define('JWT_SECRET', 'YOUR_SUPER_SECRET_KEY_12345');
define('SENDER_EMAIL', 'verify@mailvity.cc');

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

function getBearerToken() {
    $headers = getallheaders();
    if (isset($headers['Authorization'])) {
        if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
            return $matches[1];
        }
    }
    return null;
}

function decodeJWT($token) {
    // Note: In production, use firebase/php-jwt library
    $parts = explode('.', $token);
    if (count($parts) != 3) return null;
    $payload = json_decode(base64_decode($parts[1]), true);
    return $payload;
}

function verifyAuth() {
    $token = getBearerToken();
    if (!$token) {
        http_response_code(401);
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }
    $user = decodeJWT($token);
    if (!$user) {
        http_response_code(401);
        echo json_encode(['error' => 'Invalid token']);
        exit;
    }
    return $user;
}

function verifyRole($allowedRoles = ['admin']) {
    $user = verifyAuth();
    if (!in_array($user['role'], $allowedRoles)) {
        http_response_code(403);
        echo json_encode(['error' => 'Forbidden: Insufficient permissions']);
        exit;
    }
    return $user;
}
?>