
<?php
require_once 'config.php';

$user = verifyAuth();
$jobId = $_GET['jobId'] ?? null;

if (!$jobId) {
    http_response_code(400);
    echo json_encode(['error' => 'Job ID required']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM verification_jobs WHERE id = ? AND user_id = ?");
$stmt->execute([$jobId, $user['id']]);
$job = $stmt->fetch();

if (!$job) {
    http_response_code(404);
    echo json_encode(['error' => 'Job not found']);
    exit;
}

// Fetch individual results
$stmt = $pdo->prepare("SELECT email, status, confidence, reason FROM verification_results WHERE job_id = ?");
$stmt->execute([$jobId]);
$results = $stmt->fetchAll();

$job['results'] = $results;

echo json_encode($job);
?>
