
<?php
require_once 'config.php';
require_once 'VerificationEngine.php';

$user = verifyAuth();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $emails = $data['emails'] ?? [];

    if (empty($emails)) {
        http_response_code(400);
        echo json_encode(['error' => 'No emails provided']);
        exit;
    }

    // Check Credits
    $stmt = $pdo->prepare("SELECT credits_balance FROM users WHERE id = ?");
    $stmt->execute([$user['id']]);
    $balance = $stmt->fetchColumn();

    if ($balance < count($emails)) {
        http_response_code(402);
        echo json_encode(['error' => 'Insufficient credits']);
        exit;
    }

    $jobId = 'J-' . uniqid();
    
    // Create Job Entry
    $stmt = $pdo->prepare("INSERT INTO verification_jobs (id, user_id, total_emails, status) VALUES (?, ?, ?, 'processing')");
    $stmt->execute([$jobId, $user['id'], count($emails)]);

    // Deduct Credits
    $stmt = $pdo->prepare("UPDATE users SET credits_balance = credits_balance - ? WHERE id = ?");
    $stmt->execute([count($emails), $user['id']]);

    // Async processing would usually use a queue (Redis/RabbitMQ)
    // For this implementation, we simulate sequential processing for simplicity
    $engine = new VerificationEngine($pdo);
    foreach ($emails as $email) {
        $result = $engine->verifyEmail($email);
        
        $stmt = $pdo->prepare("INSERT INTO verification_results (job_id, email, status, confidence, reason) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$jobId, $result['email'], $result['status'], $result['confidence'], $result['reason']]);
        
        $pdo->prepare("UPDATE verification_jobs SET processed_emails = processed_emails + 1 WHERE id = ?")->execute([$jobId]);
    }

    $pdo->prepare("UPDATE verification_jobs SET status = 'completed' WHERE id = ?")->execute([$jobId]);

    echo json_encode(['jobId' => $jobId, 'message' => 'Verification job started']);
}
?>
