
export enum VerificationStatus {
  VALID = 'Valid',
  INVALID = 'Invalid',
  CATCH_ALL = 'Catch-All',
  UNKNOWN = 'Unknown'
}

export type UserRole = 'admin' | 'support' | 'user';
export type UserStatus = 'active' | 'suspended' | 'pending';

export interface VerificationResult {
  email: string;
  status: VerificationStatus;
  confidence: number;
  reason: string;
}

export interface Job {
  id: string;
  total: number;
  processed: number;
  status: 'pending' | 'processing' | 'completed' | 'failed';
  results?: VerificationResult[];
}

export interface User {
  id: string;
  email: string;
  credits: number;
  plan: 'free' | 'pro' | 'enterprise';
  verifiedToday: number;
  role: UserRole;
  status: UserStatus;
  isAdmin?: boolean; // Kept for backward compatibility if needed, but role is preferred
}

export interface AuthState {
  user: User | null;
  token: string | null;
  isAuthenticated: boolean;
}
