
<?php
require_once '../config.php';

// Restricted to Admin and Support roles
$caller = verifyRole(['admin', 'support']);

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? 'list';

if ($method === 'GET') {
    try {
        $stmt = $pdo->query("SELECT id, email, credits_balance as credits, plan_type as plan, role, status, created_at FROM users ORDER BY created_at DESC");
        echo json_encode($stmt->fetchAll());
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to fetch user list']);
    }
} elseif ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $targetUserId = $data['userId'] ?? null;

    if (!$targetUserId) {
        http_response_code(400);
        echo json_encode(['error' => 'Target User ID required']);
        exit;
    }

    // Role elevation and deletion requires super-admin permissions
    if (isset($data['role']) || $action === 'delete') {
        verifyRole(['admin']);
    }

    try {
        if ($action === 'delete') {
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
            $stmt->execute([$targetUserId]);
            echo json_encode(['success' => true]);
        } else if ($action === 'update') {
            $fields = [];
            $params = [];
            
            $allowed = ['credits', 'plan', 'role', 'status'];
            foreach ($allowed as $f) {
                if (isset($data[$f])) {
                    $dbF = ($f === 'credits') ? 'credits_balance' : (($f === 'plan') ? 'plan_type' : $f);
                    $fields[] = "$dbF = ?";
                    $params[] = $data[$f];
                }
            }
            
            if (empty($fields)) {
                echo json_encode(['error' => 'No fields to update']);
                exit;
            }

            $params[] = $targetUserId;
            $stmt = $pdo->prepare("UPDATE users SET " . implode(', ', $fields) . " WHERE id = ?");
            $stmt->execute($params);
            echo json_encode(['success' => true]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Admin operation failed']);
    }
}
?>
