
<?php
require_once 'config.php';

// Endpoint for Stripe Webhook
if (isset($_GET['webhook']) && $_GET['webhook'] === 'stripe') {
    $payload = file_get_contents('php://input');
    $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'] ?? '';

    // Verify signature logic would go here in production with SDK
    $event = json_decode($payload, true);

    if ($event['type'] === 'checkout.session.completed') {
        $session = $event['data']['object'];
        $userId = $session['client_reference_id'];
        $credits = $session['metadata']['credits'] ?? 0;
        $plan = $session['metadata']['plan'] ?? 'free';
        $amount = $session['amount_total'] / 100;

        try {
            $pdo->beginTransaction();
            
            // Update User Credits and Plan
            $stmt = $pdo->prepare("UPDATE users SET credits_balance = credits_balance + ?, plan_type = ? WHERE id = ?");
            $stmt->execute([$credits, $plan, $userId]);

            // Log Transaction
            $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, credits_added, payment_method, external_reference) VALUES (?, ?, ?, 'stripe', ?)");
            $stmt->execute([$userId, $amount, $credits, $session['id']]);

            $pdo->commit();
            http_response_code(200);
            echo json_encode(['status' => 'success']);
        } catch (Exception $e) {
            $pdo->rollBack();
            http_response_code(500);
            error_log("Payment Processing Error: " . $e->getMessage());
        }
    }
    exit;
}

// Endpoint for Crypto Callback (Generic placeholder)
if (isset($_GET['webhook']) && $_GET['webhook'] === 'crypto') {
    $data = json_decode(file_get_contents('php://input'), true);
    // Add logic here to verify callback signature from your crypto provider
    if (isset($data['status']) && $data['status'] === 'confirmed') {
        $userId = $data['user_id'];
        $credits = $data['credits'];
        $orderId = $data['order_id'];
        
        $stmt = $pdo->prepare("UPDATE users SET credits_balance = credits_balance + ? WHERE id = ?");
        $stmt->execute([$credits, $userId]);
        
        $stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, credits_added, payment_method, external_reference) VALUES (?, ?, ?, 'crypto', ?)");
        $stmt->execute([$userId, $data['amount'], $credits, $orderId]);
    }
    exit;
}
?>
