<?php
// Production Backend Configuration - Mailvity.cc /v1/
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

// Database Credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'moonzbqz_mailvity');
define('DB_USER', 'moonzbqz_mailvityuser');
define('DB_PASS', 'D77e{5Guj%sb');

// Security & Authentication
define('JWT_SECRET', 'MAILVITY_PROD_SECURE_PHRASE_2025_#');
define('SENDER_EMAIL', 'verify@mailvity.cc');

// GATEWAY CONFIGURATION
// Add your keys here to complete setup
define('STRIPE_SECRET_KEY', 'sk_live_YOUR_STRIPE_KEY'); 
define('STRIPE_WEBHOOK_SECRET', 'whsec_YOUR_WEBHOOK_SECRET');
define('CRYPTO_API_KEY', 'YOUR_CRYPTO_GATEWAY_KEY'); 

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Critical: Database connection failed']);
    exit;
}

function getBearerToken() {
    $headers = getallheaders();
    if (isset($headers['Authorization'])) {
        if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
            return $matches[1];
        }
    }
    return null;
}

function decodeJWT($token) {
    $parts = explode('.', $token);
    if (count($parts) != 3) return null;
    $payload = json_decode(base64_decode($parts[1]), true);
    if (isset($payload['exp']) && $payload['exp'] < time()) return null;
    return $payload;
}

function verifyAuth() {
    $token = getBearerToken();
    if (!$token) {
        http_response_code(401);
        echo json_encode(['error' => 'Authentication required']);
        exit;
    }
    $user = decodeJWT($token);
    if (!$user) {
        http_response_code(401);
        echo json_encode(['error' => 'Session expired or invalid']);
        exit;
    }
    return $user;
}

function verifyRole($allowedRoles = ['admin']) {
    $user = verifyAuth();
    if (!in_array($user['role'], $allowedRoles)) {
        http_response_code(403);
        echo json_encode(['error' => 'Access denied: Insufficient permissions']);
        exit;
    }
    return $user;
}
?>